const Inscricao = require('../models/Inscricao');

// Debug: Verifique o que está sendo importado
console.log('Inscricao importado:', Inscricao);
console.log('Métodos disponíveis:', Object.keys(Inscricao));


exports.renderHome = (req, res) => {
  res.render('index', {
    title: 'Curso de Gestão de Projetos para Engenheiros',
    activePage: 'home',
    turmas: [
      {
        value: "Turma 1 (12/04 – 03/05/2025)",
        label: "Turma 1 (12/04 – 03/05/2025): Aos sábados das 8:30 – 13:00"
      },
      {
        value: "Turma 2 (21 – 30/04/2025)",
        label: "Turma 2 (21 – 30/04/2025): Seg. a sexta-feira das 17:00 – 19:30"
      }
    ],
    dadosBancarios: {
      banco: "Bai",
      conta: "9848701410001",
      iban: "0040.0000.9848.7014.1014.9",
      whatsapp: "944683483"
    }
  });
};

exports.processarInscricao = async (req, res) => {
  try {
    const { nome, telefone, email, turma } = req.body;
    
    // Validar dados
    if (!nome || !telefone || !email || !turma) {
      return res.status(400).json({
        success: false,
        message: 'Todos os campos são obrigatórios'
      });
    }

    // Verificar se e-mail já está cadastrado
    const existeEmail = await Inscricao.buscarPorEmail(email);
    if (existeEmail) {
      return res.status(400).json({
        success: false,
        message: 'Este e-mail já está cadastrado'
      });
    }

    // Criar inscrição no banco de dados
    const inscricaoId = await Inscricao.criar(nome, telefone, email, turma);

    res.json({ 
      success: true,
      message: 'Inscrição realizada com sucesso!',
      inscricaoId
    });
  } catch (error) {
    console.error('Erro ao processar inscrição:', error);
    res.status(500).json({
      success: false,
      message: 'Ocorreu um erro ao processar sua inscrição.'
    });
  }
};